#!/bin/bash
# Train R36 - PortMaster launcher script
# Compatible with older ArkOS versions

# PortMaster environment setup
if [ -d "/opt/system/Tools/PortMaster/" ]; then
    controlfolder="/opt/system/Tools/PortMaster"
elif [ -d "/opt/tools/PortMaster/" ]; then
    controlfolder="/opt/tools/PortMaster"
elif [ -d "/roms/ports/PortMaster/" ]; then
    controlfolder="/roms/ports/PortMaster"
else
    controlfolder=""
fi

# Source control files if they exist
if [ -n "$controlfolder" ] && [ -f "$controlfolder/control.txt" ]; then
    source "$controlfolder/control.txt"
fi

if [ -n "$controlfolder" ] && [ -f "$controlfolder/tasksetter" ]; then
    source "$controlfolder/tasksetter"
fi

# Call get_controls if available
if type get_controls &>/dev/null; then
    get_controls
fi

# Set GAMEDIR - use directory variable if set, otherwise detect from script location
if [ -n "$directory" ]; then
    GAMEDIR="/$directory/ports/train"
else
    GAMEDIR="$(dirname "$(realpath "$0")")/train"
fi

cd "$GAMEDIR" || exit 1

# Start gptokeyb if available
if [ -n "$GPTOKEYB" ] && [ -f "$GAMEDIR/train.gptk" ]; then
    $GPTOKEYB "train.aarch64" -c "$GAMEDIR/train.gptk" &
elif command -v gptokeyb &>/dev/null && [ -f "$GAMEDIR/train.gptk" ]; then
    gptokeyb "train.aarch64" -c "$GAMEDIR/train.gptk" &
fi

# Run the game
if [ -n "$TASKSET" ]; then
    $TASKSET ./train.aarch64
else
    ./train.aarch64
fi

# Cleanup
if [ -n "$ESUDOKILL" ]; then
    $ESUDOKILL
fi

# Kill gptokeyb if we started it
pkill -9 gptokeyb 2>/dev/null
